//var wsUri = "ws://"+location.hostname+":9015";
//var websocket = null;

let gInitialValues = {};
let gInitialEnvironment = '0'; 
let gInitFunctionEnable = false; 
let gViscaWaitingAckTime = 10;
var gNimbleEyeTrigerStableRangeTime = 0.8;
var gNimbleEyeDisplayDectionRangeTime = 0.8;

const inputMap = {
    'gBLSNoiseLevelThreshold': 'NoiseLevelThreshold',
    'gBLSDistanceDiff_X': 'DistanceDiff_X',
    'gBLSDistanceDiff_Y': 'DistanceDiff_Y',
    'gBLSdBDiff': 'dBDiff',
    'gBLSChangeSelecMictTime': 'ChangeSelecMictTime',
    'gBLSHistorySize': 'HistorySize',
    'gBLSSwitchThreshold': 'SwitchThreshold',
    'gBLSDistanceWight': 'DistanceWight',
    'gBLSdBWeight': 'dBWeight',
    'gBLSmaxTracksSize': 'maxTracksSize',
    'gBLSmicDataSaveWindowSize': 'micDataSaveWindowSize',
    'environmentSelect':'environmentSelect',
};

const inputIds = [
    'gBLSNoiseLevelThreshold',
    'gBLSDistanceDiff_X',
    'gBLSDistanceDiff_Y',
    'gBLSdBDiff',
    'gBLSChangeSelecMictTime',
    'gBLSHistorySize',
    'gBLSSwitchThreshold',
    'gBLSDistanceWight',
    'gBLSdBWeight',
    'gBLSmaxTracksSize',
    'gBLSmicDataSaveWindowSize',
    'environmentSelect',
];

const applyButton = document.getElementById('applyDebugSetupButton');
const cancelButton = document.getElementById('cancelDebugSetupButton');

function sendMessageAbout(cmd,data) {

    var msg = cmd;

    if ( websocket != null )
    {

        var jsonmsg = {};

        jsonmsg.Command = msg;
        
        if(msg == "SetDebugModeStatus"){
            jsonmsg = data; //AddCamera
        } 
        else if(msg == "SetPipOutputSetting"){
            jsonmsg = data;
        }     

        if (websocket.readyState == 1) {
        websocket.send( JSON.stringify(jsonmsg) );
            //console.log( "string sent :", JSON.stringify(jsonmsg) );
        }
        else {
            //do something
            console.log( "websocket.readyState :", websocket.readyState );
            if(websocket.readyState == 3)
            {
                gWebSocketErrorBlockUIPage = true;
                blockUIforPage();
                setLoginStatus(false);
                gHadLogin = false;
                clearLoginStatus();
            }
        }
    }
}

function receivedDataAbout(data) {

    var tempData = data;
    var obj = JSON.parse(tempData);

    //console.log('obj.Reply:',obj.Reply);

    switch (obj.Reply) {

        case "GetCurrentVersion": //reply Video Output Setting result
            //console.log('GetCurrentVersion!!');
            updatedCurrentVersion(obj);
            break;

        /*case "OTAProgress": //reply Video Output Setting result
            console.log('OTAProgress!!');
            updatedOTAResp(obj);
        break;*/

        case "GetNetworkSetting":
            updatedMacAddress(obj);
            break;

        case "GetSerialNumber":
            updatedSerialNumber(obj);
            break;

        case "GetStandByStatus":
            updatedGetStandByStatus(obj);
            break;
        case "GetSoundMaxQtyProcessStatus":
            updatedGetSoundMaxQtyProcessStatus(obj);
            break;

        case "GetVideoIsStartStreaming":
            //console.log('GetVideoIsStartStreaming!!');
            gIsVideoStart = getVideoStreamingStatus(obj);
            break;

        case "StartVideoStreaming":
            //console.log('StartVideoStreaming!!');
            updatedStartVideoStreaming(obj,false);
            break;

        case "StopVideoStreaming":
            //console.log('StopVideoStreaming!!');
            updatedStopVideoStreaming(obj);
            break;

        case "GetDebugModeStatus":
            updatedGetDebugModeStatus(obj);
            break;

        case "CheckDanteActiveDataIsExport":
            updatedCheckDanteActiveDataIsExport(obj);
            break;

        case "GetSystemSetting":
            updatedCheckSystemSetting(obj);
            break;
        case "GetScheduleRebootSetting":
            updatedScheduleRebootSetting(obj);
            break;
        case "GetPipOutputSetting": //reply Video Output Setting result
            //console.log('GetPipOutputSetting',obj);
            updatePipMode(obj);
            break;
        case "GetCameraList":
            updatedConnectedList(obj);
            updatedPipPositionValue();
            break;
    }

}

function updatedCheckSystemSetting(obj) {
    function simpleHash(obj) 
    {
        const str = JSON.stringify(obj);
        let hash = 0;
        for (let i = 0; i < str.length; i++) 
        {
            const char = str.charCodeAt(i);
            hash = ((hash << 5) - hash) + char;
            hash = hash & hash;
        }
        return hash;
    }
    
    if (typeof updatedCheckSystemSetting.lastHash === 'undefined') {
        updatedCheckSystemSetting.lastHash = null;
    }
    
    const currentHash = simpleHash(obj);
    
    if (currentHash === updatedCheckSystemSetting.lastHash) {
        //console.log('updatedCheckSystemSetting: Duplicate data detected, skipping');
        return;
    }
    
    updatedCheckSystemSetting.lastHash = currentHash;
    
    gViscaWaitingAckTime = obj.System.ViscaCommandWaitingAckTime;

    gNimbleEyeTrigerStableRangeTime = obj.System.NimbleEyeTrigerStableRangeTime;
    gNimbleEyeDisplayDectionRangeTime = obj.System.NimbleEyeDisplayDectionRangeTime;

    gInputNimbleEyeX = obj.System.NimbleEyeInputX;
    gInputNimbleEyeY = obj.System.NimbleEyeInputY;
    gInputNimbleEyeD = obj.System.NimbleEyeInputD;
    gInputNimbleEyeTiltSlope = obj.System.NimbleEyeInputTiltSlope;
    gInputNimbleEyePanSlope = obj.System.NimbleEyeInputPanSlope;
}

function updatedCurrentVersion(obj)
{
    $("#manufacturerSpan").text("Lumens Digital Optics Inc.");
    $("#modelNameSpan").text("AI-Box1");
    $("#curfirmwareSpan").text(obj.Version);
    $("#A_WebSite").text("www.MyLumens.com").prop("href", "https://www.mylumens.com/");
    $("#Select_Profile").hide();
    $("#Label_Profile").hide();
}

function updatedMacAddress(obj)
{
    $("#macAddressSpan").text(obj.Network.Mac);
}

function updatedSerialNumber(obj)
{
    $("#serialSpan").text(obj.SerialNumber);
}

function getVideoStreamingStatus(msg) {
    var isStartStreaming = -1;
    if (msg.IsStartStreaming == true) {
        disabledLeftMenu(); // on streaming, disable left menu
        isStartStreaming = 1;
    }
    else {
        isStartStreaming = 0;
    }
    updateVideoOnOffButton(isStartStreaming);
    return isStartStreaming;
}

function initWebSocketAbout() {

    if (websocket && websocket.readyState == 1) {
        console.log('Already connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageAbout("GetVideoIsStartStreaming");
        sendMessageAbout("GetCurrentVersion");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageAbout("GetNetworkSetting");
        sendMessageAbout("GetSerialNumber");
        sendMessageAbout('GetDebugModeStatus');
        sendMessageAbout('GetDebugModeBLS');
        sendMessageIndex("CheckDanteActiveDataIsExport");
        sendMessageSettings("GetSystemSetting");
        sendMessageSettings("GetScheduleRebootSetting");


        const copyrightSpan = document.getElementById("Span_Copyright");

        if (gCheckFiveTimeToDebugMode >= 5) 
        {
            copyrightSpan.style.textDecoration = "underline";
            copyrightSpan.style.cursor = "pointer";
            copyrightSpan.onclick = function () 
            {
                if (document.getElementById("Div_DebugMode_content")) 
                {
                    document.getElementById("Div_DebugMode_content").style.display = "block";

                    if(document.getElementById("inputViscaWaitingAckTime"))
                        document.getElementById("inputViscaWaitingAckTime").value = gViscaWaitingAckTime;

                    if(document.getElementById("inputNimbleEyeTrigerStableRangeTime"))
                        document.getElementById("inputNimbleEyeTrigerStableRangeTime").value = gNimbleEyeTrigerStableRangeTime;

                    if(document.getElementById("inputNimbleEyeDisplayDectionRangeTime"))
                        document.getElementById("inputNimbleEyeDisplayDectionRangeTime").value = gNimbleEyeDisplayDectionRangeTime;
                
                    if(document.getElementById("inputNimbleEyeX"))
                        document.getElementById("inputNimbleEyeX").value = gInputNimbleEyeX;
                    if(document.getElementById("inputNimbleEyeY"))
                        document.getElementById("inputNimbleEyeY").value = gInputNimbleEyeY;
                    if(document.getElementById("inputNimbleEyeD"))
                        document.getElementById("inputNimbleEyeD").value = gInputNimbleEyeD;
                    if(document.getElementById("inputNimbleEyeTiltSlope"))
                        document.getElementById("inputNimbleEyeTiltSlope").value = gInputNimbleEyeTiltSlope;
                    if(document.getElementById("inputNimbleEyePanSlope"))
                        document.getElementById("inputNimbleEyePanSlope").value = gInputNimbleEyePanSlope;

                }
                if (document.getElementById("Div_content")) 
                {
                    document.getElementById("Div_content").style.display = "none";
                }
            };
        } 
        else 
        {
            copyrightSpan.style.textDecoration = "none";
            copyrightSpan.style.cursor = "default";
            copyrightSpan.onclick = null;
        }
    }
    else
    {
        if(gProtocolStr == "http:")
            websocket = new WebSocket( wsUri );
        else
            websocket = new WebSocket( wssUri );
    }

    websocket.addEventListener('open', function() {
        console.log('open connection');
        gWebSocketErrorBlockUIPage = false;
        UnblockUIforPage();
        sendMessageAbout("GetVideoIsStartStreaming");
        sendMessageAbout("GetCurrentVersion");
        sendMessageIndex("GetCurrentProfileID");
        sendMessageAbout("GetNetworkSetting");
        sendMessageAbout("GetSerialNumber");
        sendMessageAbout('GetDebugModeStatus');
        sendMessageAbout('GetDebugModeBLS');
        sendMessageIndex("CheckDanteActiveDataIsExport");
        sendMessageSettings("GetSystemSetting");
        sendMessageSettings("GetScheduleRebootSetting");

        const copyrightSpan = document.getElementById("Span_Copyright");

        if (gCheckFiveTimeToDebugMode >= 5) 
        {
            copyrightSpan.style.textDecoration = "underline";
            copyrightSpan.style.cursor = "pointer";
            copyrightSpan.onclick = function () 
            {
                if (document.getElementById("Div_DebugMode_content")) 
                {
                    document.getElementById("Div_DebugMode_content").style.display = "block";

                    if(document.getElementById("inputViscaWaitingAckTime"))
                        document.getElementById("inputViscaWaitingAckTime").value = gViscaWaitingAckTime;
                    if(document.getElementById("inputNimbleEyeTrigerStableRangeTime"))
                        document.getElementById("inputNimbleEyeTrigerStableRangeTime").value = gNimbleEyeTrigerStableRangeTime;
                    if(document.getElementById("inputNimbleEyeDisplayDectionRangeTime"))
                        document.getElementById("inputNimbleEyeDisplayDectionRangeTime").value = gNimbleEyeDisplayDectionRangeTime;
                }
                if (document.getElementById("Div_content")) 
                {
                    document.getElementById("Div_content").style.display = "none";
                }
            };
        } 
        else 
        {
            copyrightSpan.style.textDecoration = "none";
            copyrightSpan.style.cursor = "default";
            copyrightSpan.onclick = null;
        }
        
    });

    websocket.addEventListener('message',function(evt){
        if(evt.data instanceof Blob)
        {
                
        }
        else
        {
            receivedDataAbout(evt.data);
        } 
    });

    websocket.onerror = function(evt) 
    {
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };

    websocket.onclose = function(evt) 
    {
        console.log(' websocket.onclose');
        gWebSocketErrorBlockUIPage = true;
        setLoginStatus(false);
        gHadLogin = false;
        clearLoginStatus();
        setTimeout(showWebSocketLost,1000);//blockUIforPage();
    };

}

function reloadAbout() {
    openAbout();
}

function openAbout() {
    $("#DivMainPage").load("./page/about.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        initWebSocketAbout();
        initTabSwitching();
    });
}

function onDebugModeChange(e){
    isDebugModeDisplay = e.checked;

    var jsonmsg = {};
    jsonmsg.Command = "SetDebugModeStatus";
    jsonmsg.DebugModeEnable = isDebugModeDisplay;
    sendMessageAbout("SetDebugModeStatus", jsonmsg);

    updateCheckboxState();
}

var gIsNimbleEyeShowBox = false
function onNimbleEyeShowBoxChange(e){
    gIsNimbleEyeShowBox = e.checked;

    updateNimbleEyeShowBoxChangeState();
}

function onFunctionChange(e)
{
    const applyButton = document.getElementById('applyDebugSetupButton');
    const cancelButton = document.getElementById('cancelDebugSetupButton');
    const debugMessageBox = document.getElementById('debugExecutionMessageBox');
    const clearButton = document.getElementById('clearDebugMessagesButton');
    const outputButton = document.getElementById('outputDebugMessagesButton');

    if (clearButton) {
        clearButton.disabled = !e.checked;
    }
    if (outputButton) {
        outputButton.disabled = !e.checked;
    }

    if (applyButton && cancelButton) 
    {
        applyButton.disabled = false;
        cancelButton.disabled = false;
    }

    if (debugMessageBox) 
    {
        debugMessageBox.style.display = e.checked ? 'block' : 'none';
        //console.log(`Debug message box display set to: ${debugMessageBox.style.display}`);
    }
}

function outputDebugMessages() {
    const debugMessages = document.getElementById('debugMessages');
    if (!debugMessages) {
        console.warn('Debug messages container not found');
        return;
    }

    const content = messageHistory.join('\n');
    if (!content.trim()) {
        console.warn('No debug messages to export');
        return;
    }

    const now = new Date();
    const timestamp = now.toISOString().replace(/[:.]/g, '-');
    const filename = `DebugMessages_${timestamp}.txt`;

    const blob = new Blob([content], { type: 'text/plain' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);

    console.log('Debug messages exported to file');
}

function clearDebugMessages() {
    const debugMessages = document.getElementById('debugMessages');
    if (!debugMessages) {
        console.warn('Debug messages container not found');
        return;
    }

    debugMessages.textContent = '';
    messageHistory = [];
    console.log('Debug messages cleared');
}

function updateCheckboxState() {
    const checkbox = document.getElementById("SetDebugModeCheckboxInput");
    if (checkbox) {
        checkbox.checked = isDebugModeDisplay;
    }
}

function updateNimbleEyeShowBoxChangeState() {
    const checkbox = document.getElementById("SetNimbleEyeShowBoxCheckboxInput");
    if (checkbox) {
        checkbox.checked = gIsNimbleEyeShowBox;
    }
}

function updateFunctionCheckboxState() {
    const checkbox = document.getElementById("SetFunctionCheckboxInput");
    if (checkbox) {
        checkbox.checked = isFunctionDisplay;
    }
}

let lastProcessedMessage = null;

function updatedGetDebugModeStatus(msg){

    if (msg.GetRawMessage) 
    {
        appendDebugMessage(msg.GetRawMessage);
    }

    const currentMessage = {
        DebugModeSetup: msg.DebugModeSetup,
        ...Object.keys(inputMap).reduce((acc, id) => {
            const msgKey = inputMap[id];
            if (msg[msgKey] !== undefined) {
                acc[msgKey] = msg[msgKey];
            }
            return acc;
        }, {})
    };

    const currentMessageString = JSON.stringify(currentMessage);
    if (lastProcessedMessage && JSON.stringify(lastProcessedMessage) === currentMessageString) 
    {
        return;
    }

    lastProcessedMessage = currentMessage;

    if(msg.DebugModeSetup)
    {
        gBLSSaveDataIsCheck = true;
        getBC200dataUnblockUIforPage();
    }
    else
    {
        if(msg.DebugModeEnable)
        {
            isDebugModeDisplay = msg.DebugModeEnable;
            updateCheckboxState();
        }
    
        Object.keys(inputMap).forEach(id => {
            const msgKey = inputMap[id];
            if (msg[msgKey] !== undefined) 
            {
                const input = document.getElementById(id);
                if (input) 
                {
                    input.value = msg[msgKey].toString();
                    gInitialValues[id] = input.value;
                }
            }
        });
    
        if(applyButton)
            applyButton.disabled = true;
        if(cancelButton)
            cancelButton.disabled = true;
    }
    

}

let messageHistory = [];
const MAX_HISTORY_LINES = 100000;

function appendDebugMessage(msg) {
    const debugMessages = document.getElementById('debugMessages');
    if (!debugMessages) {
        console.warn('Debug messages container not found.');
        return;
    }

    // Generate timestamp with milliseconds
    const now = new Date();
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    const hour = String(now.getHours()).padStart(2, '0');
    const minute = String(now.getMinutes()).padStart(2, '0');
    const second = String(now.getSeconds()).padStart(2, '0');
    const milliseconds = String(now.getMilliseconds()).padStart(3, '0');
    const timestamp = `${year}/${month}/${day}, ${hour}:${minute}:${second}:${milliseconds}`;

    // Format display message (readable multi-line)
    let displayMessage = `[${timestamp}] Mic Status: `;
    displayMessage += `Select Mic ${msg.SelectMic}\n`;
    if (msg.Mics && Array.isArray(msg.Mics)) {
        msg.Mics.forEach(mic => {
            displayMessage += `  Mic ${mic.MicID}`;
            displayMessage += `  dB: ${mic.dB}`;
            displayMessage += `  Distance: ${mic.distance}`;
            displayMessage += `  Distance Score: ${mic.distScore.toFixed(4)}`;
            displayMessage += `  dB Score: ${mic.dbScore.toFixed(4)}`;
            displayMessage += `  Adjusted Score: ${mic.adjustedScore.toFixed(4)}`;
            displayMessage += `  Average Score: ${mic.avgScore.toFixed(4)}\n`;
        });
    }

    let historyMessage = `${timestamp},SelectMic=${msg.SelectMic}\n`;
    if (msg.Mics && Array.isArray(msg.Mics)) {
        msg.Mics.forEach(mic => {
            historyMessage += `Mic${mic.MicID}:dB=${mic.dB},dist=${mic.distance},distScore=${mic.distScore.toFixed(4)},dbScore=${mic.dbScore.toFixed(4)},adjScore=${mic.adjustedScore.toFixed(4)},avgScore=${mic.avgScore.toFixed(4)}\n`;
        });
    }

    debugMessages.textContent = displayMessage;

    messageHistory.push(historyMessage);
    const historyLines = messageHistory.join('').split('\n');
    if (historyLines.length > MAX_HISTORY_LINES) {
        const excessLines = historyLines.length - MAX_HISTORY_LINES;
        messageHistory = historyLines.slice(excessLines);
    }

    // Scroll to bottom
    debugMessages.scrollTop = debugMessages.scrollHeight;
}

function initTabSwitching() {

    const tabs = document.querySelectorAll('.set-tabs-menu');
    const tabContents = document.querySelectorAll('.tabs-content');

    tabs.forEach(tab => {
        tab.addEventListener('click', (e) => {
            e.preventDefault();

            tabs.forEach(t => t.classList.remove('set-tabs-menu-active'));
            tab.classList.add('set-tabs-menu-active');
            tabContents.forEach(content => content.style.display = 'none');

            const target = tab.getAttribute('data-target');
            if (target === 'tabOptimization') 
            {
                sendMessageSettings("GetSystemSetting");
                
                document.getElementById('tabDebugMode').style.display = 'block';

            } 
            else if (target === 'tabBetaFunctions') 
            {
                if(document.getElementById('tabBLSFunction'))
                {
                    document.getElementById('tabBLSFunction').style.display = 'block';
                    initializeBLSInputs();
                }

            }
            else if (target === 'tabScheduleReboot') 
            {
                if(document.getElementById('tabScheduleRebootFunction'))
                {
                    sendMessageSettings("GetScheduleRebootSetting");
                    document.getElementById('tabScheduleRebootFunction').style.display = 'block';
                    
                }

            }
            else if (target === 'tabPip') 
            {
                if(document.getElementById('tabPipFunction'))
                {
                    sendMessageAbout("GetPipOutputSetting");
                    sendMessageVideo("GetCameraList"); 
                    document.getElementById('tabPipFunction').style.display = 'block';
                    
                }

            }
        });
    });

    const tooltipSpan = document.getElementById('BLS_Environment_Tooltip');
    if (tooltipSpan) 
    {
        const select = document.getElementById('environmentSelect');

        const environmentNames = {
            "0": "Default",
            "1": "QuietOffice",
            "2": "NoisyCafe",
            "3": "ConferenceRoom",
            "4": "LargeLectureHall",
            "5": "OutdoorEvent",
            "6": "RecordingStudio",
            "7": "TelemedicineClinic"
        };
        const tooltipKey = `BLS_Environment_${environmentNames[select.value]}_Tooltip`;
        tooltipSpan.textContent = window.LanguageManager.getTranslatedText(tooltipKey) || 'No description available';
    }

    const select = document.getElementById('environmentSelect');
    if (select) 
    {
        const selectLang = document.getElementById("GobalSelectLanguage");
        const langIndex = selectLang ? parseInt(selectLang.value, 10) : 0;
        const langCode = langIndex === 1 ? "tw" : (langIndex === 2 ? "zh" : "en");
        const translations = window.languages[langCode];

        Array.from(select.options).forEach(option => {
            const langKey = option.getAttribute("data-lang");
            if (langKey && window.LanguageManager.getTranslatedText(langKey)) 
            {
                option.textContent = window.LanguageManager.getTranslatedText(langKey);
            }
        });
    }

}

function initializeBLSInputs() {
    if (!gInitialValues || Object.keys(gInitialValues).length === 0) {
        return;
    }

    inputIds.forEach(id => {
        const input = document.getElementById(id);
        if (input) {
            input.value = gInitialValues[id] || '';
            gInitialValues[id] = input.value;
        }
    });

    const applyButton = document.getElementById('applyDebugSetupButton');
    const cancelButton = document.getElementById('cancelDebugSetupButton');
    if (applyButton && cancelButton) {
        applyButton.disabled = true;
        cancelButton.disabled = true;
    }
}

let isDebugMessageBoxDragging = false;
let debugMessageCurrentX;
let debugMessageCurrentY;

document.addEventListener('DOMContentLoaded', () => {
    const applyButton = document.getElementById('applyDebugSetupButton');
    const cancelButton = document.getElementById('cancelDebugSetupButton');

    // Change tracking
    const hasChanges = () => {
        return inputIds.some(id => {
            const input = document.getElementById(id);
            return input && input.value !== (gInitialValues[id] || '');
        });
    };

    const toggleButtons = () => {
        const changed = hasChanges();
        if (applyButton && cancelButton) {
            applyButton.disabled = !changed;
            cancelButton.disabled = !changed;
        }
    };

    // Add input event listeners
    inputIds.forEach(id => {
        const input = document.getElementById(id);
        if (input) {
            input.addEventListener('input', toggleButtons);
        }
    });

    // Initialize BLS inputs if tab is visible
    if(document.getElementById('tabBLSFunction'))
    {
        if (document.getElementById('tabBLSFunction').style.display === 'block') 
        {
            initializeBLSInputs();
        }   
    }
});

var gWaitBLSSaveDataBefore = false;
let gBLSSaveDataIsCheck = false;


function viscaInputChange()
{
    const inputElement = document.getElementById('inputViscaWaitingAckTime');
    const applyElement = document.getElementById('applyViscaSetupButton');
    const cancelElement = document.getElementById('cancelViscaSetupButton');
    if(inputElement)
    {
        if(inputElement.value > 10)
        {
            inputElement.value = 10;
        }
        else if (inputElement.value < 0)
        {
            inputElement.value = 0;
        }
    }

    if(applyElement)
        applyElement.disabled = false;
    if(cancelElement)
        cancelElement.disabled = false;
    
}


function NimbleEyeDisplayDectionRangeInputChange()
{
    const inputElement = document.getElementById('inputNimbleEyeDisplayDectionRangeTime');

    const applyElement = document.getElementById('applyNimbleEyeDisplayDectionRangeButton');
    const cancelElement = document.getElementById('cancelNimbleEyeDisplayDectionRangeButton');
    
    if(inputElement)
    {
        if(inputElement.value > 5)
        {
            inputElement.value = 5;
        }
        else if (inputElement.value < 0)
        {
            inputElement.value = 0;
        }
    }

    if(applyElement)
        applyElement.disabled = false;
    if(cancelElement)
        cancelElement.disabled = false;
    
}

function NimbleEyeTrigerStableRangeInputChange()
{
    const inputElement = document.getElementById('inputNimbleEyeTrigerStableRangeTime');

    const applyElement = document.getElementById('applyNimbleEyeTrigerStableRangeButton');
    const cancelElement = document.getElementById('cancelNimbleEyeTrigerStableRangeButton');
    
    if(inputElement)
    {
        if(inputElement.value > 5)
        {
            inputElement.value = 5;
        }
        else if (inputElement.value < 0)
        {
            inputElement.value = 0;
        }
    }

    if(applyElement)
        applyElement.disabled = false;
    if(cancelElement)
        cancelElement.disabled = false;
    
}

var gInputNimbleEyeX = 0;
var gInputNimbleEyeY = 0;
var gInputNimbleEyeD = 0.0;
var gInputNimbleEyeTiltSlope = 0.0;
var gInputNimbleEyePanSlope = 0.0;

function NimbleEyeDataChangeInputChange()
{
    const inputD = document.getElementById('inputNimbleEyeD');
    const inputTiltSlope = document.getElementById('inputNimbleEyeTiltSlope');
    const inputPanSlope = document.getElementById('inputNimbleEyePanSlope');
    
    const apply = document.getElementById('applyNimbleEyeDataSetChangeButton');
    const cancel = document.getElementById('cancelNimbleEyeDataSetChangeButton');
    
    if(inputTiltSlope)
    {
        if (inputTiltSlope.value < -100)
        {
            inputTiltSlope.value = -100;
        } 
        if (inputTiltSlope.value > 100)
        {
            inputTiltSlope.value = 100;
        }
    }

    if(inputPanSlope)
    {
        if (inputPanSlope.value < -100)
        {
            inputPanSlope.value = -100;
        } 
        if (inputPanSlope.value > 100)
        {
            inputPanSlope.value = 100;
        }
    }

    if(inputD)
    {
        if (inputD.value < 0)
        {
            inputD.value = 0;
        } 
    }
        
    if(apply)
        apply.disabled = false;
    if(cancel)
        cancel.disabled = false;

}

function NimbleEyeDataChangeInputApply()
{
    const applyElement = document.getElementById('applyNimbleEyeDataSetChangeButton');
    const cancelElement = document.getElementById('cancelNimbleEyeDataSetChangeButton');
    const inputNimbleEyeX = document.getElementById('inputNimbleEyeX');
    const inputNimbleEyeY = document.getElementById('inputNimbleEyeY');
    const inputNimbleEyeD = document.getElementById('inputNimbleEyeD');
    const inputNimbleEyeTiltSlope = document.getElementById('inputNimbleEyeTiltSlope');
    const inputNimbleEyePanSlope = document.getElementById('inputNimbleEyePanSlope');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    var jsonmsg = {};
    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};
    let objSystem = {};

    if(inputNimbleEyeX)
    {
        objSystem.NimbleEyeInputX  = parseInt(document.getElementById("inputNimbleEyeX").value,10);
    }
    if(inputNimbleEyeY)
    {
        objSystem.NimbleEyeInputY  = parseInt(document.getElementById("inputNimbleEyeY").value,10);
    }
    if(inputNimbleEyeD)
    {
        objSystem.NimbleEyeInputD  = parseFloat(document.getElementById("inputNimbleEyeD").value,10);
    }
    if(inputNimbleEyeTiltSlope)
    {
        objSystem.NimbleEyeInputTiltSlope  = parseFloat(document.getElementById("inputNimbleEyeTiltSlope").value,10);
    }
    if(inputNimbleEyePanSlope)
    {
        objSystem.NimbleEyeInputPanSlope  = parseFloat(document.getElementById("inputNimbleEyePanSlope").value,10);
    }

    Object.assign(jsonmsg.System, objSystem);

    sendMessageSettings("SetSystemSetting",jsonmsg);

}

function NimbleEyeDataChangeInputCancel() 
{
    const inputNimbleEyeX = document.getElementById('inputNimbleEyeX');
    const inputNimbleEyeY = document.getElementById('inputNimbleEyeY');
    const inputNimbleEyeD = document.getElementById('inputNimbleEyeD');
    const inputNimbleEyeTiltSlope = document.getElementById('inputNimbleEyeTiltSlope');
    const inputNimbleEyePanSlope = document.getElementById('inputNimbleEyePanSlope');
    const apply = document.getElementById('applyNimbleEyeDataSetChangeButton');
    const cancel = document.getElementById('cancelNimbleEyeDataSetChangeButton');

    if(apply)
        apply.disabled = true;
    if(cancel)
        cancel.disabled = true;


    if (inputNimbleEyeX) 
    {
        inputNimbleEyeX.value = gInputNimbleEyeX;
        inputNimbleEyeX.classList.remove('invalid-input');
    }

    if (inputNimbleEyeY) 
    {
        inputNimbleEyeY.value = gInputNimbleEyeY;
        inputNimbleEyeY.classList.remove('invalid-input');
    }

    if (inputNimbleEyeD) 
    {
        inputNimbleEyeD.value = gInputNimbleEyeD;
        inputNimbleEyeD.classList.remove('invalid-input');
    }

    if (inputNimbleEyeTiltSlope) 
    {
        inputNimbleEyeTiltSlope.value = gInputNimbleEyeTiltSlope;
        inputNimbleEyeTiltSlope.classList.remove('invalid-input');
    }

    if (inputNimbleEyePanSlope) 
    {
        inputNimbleEyePanSlope.value = gInputNimbleEyePanSlope;
        inputNimbleEyePanSlope.classList.remove('invalid-input');
    }
}

function viscaSetupCancel() 
{
    const inputElement = document.getElementById('inputViscaWaitingAckTime');
    const applyElement = document.getElementById('applyViscaSetupButton');
    const cancelElement = document.getElementById('cancelViscaSetupButton');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    if (inputElement) {
        inputElement.value = gViscaWaitingAckTime;
        inputElement.classList.remove('invalid-input');
    
        console.log('VISCA settings cancelled, restored to:', gViscaWaitingAckTime);
    }
}

function viscaSetupApply()
{
    const applyElement = document.getElementById('applyViscaSetupButton');
    const cancelElement = document.getElementById('cancelViscaSetupButton');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    var jsonmsg = {};
    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};
    let objSystem = {};

    if(document.getElementById("inputViscaWaitingAckTime"))
    {
        let waitAckTime = parseInt(document.getElementById("inputViscaWaitingAckTime").value,10);
        if(waitAckTime < 0)
            $("#inputViscaWaitingAckTime").val(0);
        else if(waitAckTime > 10)
            $("#inputViscaWaitingAckTime").val(10);

        objSystem.ViscaCommandWaitingAckTime = parseInt(document.getElementById("inputViscaWaitingAckTime").value,10);
    }

    Object.assign(jsonmsg.System, objSystem);

    sendMessageSettings("SetSystemSetting",jsonmsg);


}

function NimbleEyeTrigerStableRangeSetupCancel() 
{
    const inputElement = document.getElementById('inputNimbleEyeTrigerStableRangeTime');
    const applyElement = document.getElementById('applyNimbleEyeTrigerStableRangeButton');
    const cancelElement = document.getElementById('cancelNimbleEyeTrigerStableRangeButton');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    if (inputElement) {
        inputElement.value = gNimbleEyeTrigerStableRangeTime;
        inputElement.classList.remove('invalid-input');
    
        console.log('NimbleEye Triger Stable Range Setup settings cancelled, restored to:', gNimbleEyeTrigerStableRangeTime);
    }
}

function NimbleEyeTrigerStableRangeSetupApply()
{
    const applyElement = document.getElementById('applyNimbleEyeTrigerStableRangeButton');
    const cancelElement = document.getElementById('cancelNimbleEyeTrigerStableRangeButton');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    var jsonmsg = {};
    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};
    let objSystem = {};

    if(document.getElementById("inputNimbleEyeTrigerStableRangeTime"))
    {
        let waitAckTime = parseInt(document.getElementById("inputNimbleEyeTrigerStableRangeTime").value,10);
        if(waitAckTime < 0)
            $("#inputNimbleEyeTrigerStableRangeTime").val(0);
        else if(waitAckTime > 5)
            $("#inputNimbleEyeTrigerStableRangeTime").val(5);

        objSystem.NimbleEyeTrigerStableRangeTime = parseFloat(document.getElementById("inputNimbleEyeTrigerStableRangeTime").value,10);
    }

    Object.assign(jsonmsg.System, objSystem);

    sendMessageSettings("SetSystemSetting",jsonmsg);

}

function NimbleEyeDisplayDectionRangeSetupCancel() 
{
    const inputElement = document.getElementById('inputNimbleEyeDisplayDectionRangeTime');
    const applyElement = document.getElementById('applyNimbleEyeDisplayDectionRangeButton');
    const cancelElement = document.getElementById('cancelNimbleEyeDisplayDectionRangeButton');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    if (inputElement) {
        inputElement.value = gNimbleEyeDisplayDectionRangeTime;
        inputElement.classList.remove('invalid-input');
    
        console.log('NimbleEye Display Dection Range Setup settings cancelled, restored to:', gNimbleEyeDisplayDectionRangeTime);
    }
}

function NimbleEyeDisplayDectionRangeSetupApply()
{
    const applyElement = document.getElementById('applyNimbleEyeDisplayDectionRangeButton');
    const cancelElement = document.getElementById('cancelNimbleEyeDisplayDectionRangeButton');

    if(applyElement)
        applyElement.disabled = true;
    if(cancelElement)
        cancelElement.disabled = true;

    var jsonmsg = {};
    jsonmsg.Command = "SetSystemSetting";
    jsonmsg.System = {};
    let objSystem = {};

    if(document.getElementById("inputNimbleEyeDisplayDectionRangeTime"))
    {
        let waitAckTime = parseInt(document.getElementById("inputNimbleEyeDisplayDectionRangeTime").value,10);
        if(waitAckTime < 0)
            $("#inputNimbleEyeDisplayDectionRangeTime").val(0);
        else if(waitAckTime > 5)
            $("#inputNimbleEyeDisplayDectionRangeTime").val(5);

        objSystem.NimbleEyeDisplayDectionRangeTime = parseFloat(document.getElementById("inputNimbleEyeDisplayDectionRangeTime").value,10);
    }

    Object.assign(jsonmsg.System, objSystem);

    sendMessageSettings("SetSystemSetting",jsonmsg);


}

function debugSetupApply() 
{
    const jsonmsg = {
        Command: "SetDebugModeStatus",
        Parameters: {}
    };

    const functionCheckbox = document.getElementById('SetFunctionCheckboxInput');
    if (functionCheckbox) 
    {
        jsonmsg.Parameters['FunctionEnabled'] = functionCheckbox.checked;
        gInitFunctionEnable  = functionCheckbox.checked;
        if(!gInitFunctionEnable)
        {
            const debugMessages = document.getElementById('debugMessages');
            debugMessages.textContent = '';
            messageHistory = [];
        }
    }

    inputIds.forEach(id => {
        const input = document.getElementById(id);
        if (input) {
            const key = inputMap[id];
            jsonmsg.Parameters[key] = parseFloat(input.value) || parseInt(input.value);
            gInitialValues[id] = input.value;
        }
    });

    const environmentSelect = document.getElementById('environmentSelect');
    if (environmentSelect)
    {
        gInitialEnvironment = environmentSelect.value;
    }
    sendMessageAbout("SetDebugModeStatus", jsonmsg);

    gWaitBLSSaveDataBefore = true;
    gBLSSaveDataIsCheck = false;
    getBC200dataBlockUIforPage();

    function SaveDataIsCheck()
    {
        if(!gBLSSaveDataIsCheck)
        {
            getBC200dataUnblockUIforPage();
        }
    }

    setTimeout(SaveDataIsCheck,3000);

    const applyButton = document.getElementById('applyDebugSetupButton');
    const cancelButton = document.getElementById('cancelDebugSetupButton');
    if (applyButton && cancelButton) 
    {
        applyButton.disabled = true;
        cancelButton.disabled = true;
    }
}

function debugSetupCancel() {
    inputIds.forEach(id => {
        const input = document.getElementById(id);
        if (input && gInitialValues[id] !== undefined) {
            input.value = gInitialValues[id];
        }
    });

    const functionCheckbox = document.getElementById('SetFunctionCheckboxInput');
    if (functionCheckbox) 
    {
        functionCheckbox.checked = gInitFunctionEnable;
    }

    const environmentSelect = document.getElementById('environmentSelect');
    if (environmentSelect) {
        environmentSelect.value = gInitialEnvironment;

        const selectedConfig = environmentConfigs[gInitialEnvironment];
        if (selectedConfig) {
            Object.keys(selectedConfig).forEach(id => {
                const input = document.getElementById(id);
                if (input) {
                    input.value = selectedConfig[id].toString();
                    gInitialValues[id] = input.value;
                }
            });
        }
    }

    const tooltipSpan = document.getElementById('BLS_Environment_Tooltip');
    if (tooltipSpan) 
    {
        const select = document.getElementById('environmentSelect');
        
        const environmentNames = {
            "0": "Default",
            "1": "QuietOffice",
            "2": "NoisyCafe",
            "3": "ConferenceRoom",
            "4": "LargeLectureHall",
            "5": "OutdoorEvent",
            "6": "RecordingStudio",
            "7": "TelemedicineClinic"
        };
        const tooltipKey = `BLS_Environment_${environmentNames[select.value]}_Tooltip`;
        tooltipSpan.textContent = window.LanguageManager.getTranslatedText(tooltipKey) || 'No description available';
    }


    const applyButton = document.getElementById('applyDebugSetupButton');
    const cancelButton = document.getElementById('cancelDebugSetupButton');
    if (applyButton && cancelButton) {
        applyButton.disabled = true;
        cancelButton.disabled = true;
    }
}

function abouthandleInputChange()
{
    const applyButton = document.getElementById('applyDebugSetupButton');
    const cancelButton = document.getElementById('cancelDebugSetupButton');
    if (applyButton && cancelButton) 
    {
        applyButton.disabled = false;
        cancelButton.disabled = false;
    }

}

const environmentConfigs = {
    "0": {
        gBLSNoiseLevelThreshold: 200.0,
        gBLSDistanceDiff_X: 20,
        gBLSDistanceDiff_Y: 20,
        gBLSdBDiff: 2,
        gBLSChangeSelecMictTime: 50,
        gBLSHistorySize: 3,
        gBLSSwitchThreshold: 1.1,
        gBLSDistanceWight: 0.8,
        gBLSdBWeight: 0.2,
        gBLSmaxTracksSize: 10,
        gBLSmicDataSaveWindowSize: 5
    },
    "1": {
        gBLSNoiseLevelThreshold: 120.0,
        gBLSDistanceDiff_X: 25,
        gBLSDistanceDiff_Y: 25,
        gBLSdBDiff: 2,
        gBLSChangeSelecMictTime: 40,
        gBLSHistorySize: 2,
        gBLSSwitchThreshold: 0.9,
        gBLSDistanceWight: 0.6,
        gBLSdBWeight: 0.4,
        gBLSmaxTracksSize: 8,
        gBLSmicDataSaveWindowSize: 4
    },
    "2": {
        gBLSNoiseLevelThreshold: 200.0,
        gBLSDistanceDiff_X: 40,
        gBLSDistanceDiff_Y: 40,
        gBLSdBDiff: 4,
        gBLSChangeSelecMictTime: 60,
        gBLSHistorySize: 4,
        gBLSSwitchThreshold: 1.2,
        gBLSDistanceWight: 0.4,
        gBLSdBWeight: 0.6,
        gBLSmaxTracksSize: 15,
        gBLSmicDataSaveWindowSize: 7
    },
    "3": {
        gBLSNoiseLevelThreshold: 160.0,
        gBLSDistanceDiff_X: 35,
        gBLSDistanceDiff_Y: 35,
        gBLSdBDiff: 3,
        gBLSChangeSelecMictTime: 50,
        gBLSHistorySize: 3,
        gBLSSwitchThreshold: 1.1,
        gBLSDistanceWight: 0.5,
        gBLSdBWeight: 0.5,
        gBLSmaxTracksSize: 12,
        gBLSmicDataSaveWindowSize: 6
    },
    "4": {
        gBLSNoiseLevelThreshold: 180.0,
        gBLSDistanceDiff_X: 45,
        gBLSDistanceDiff_Y: 45,
        gBLSdBDiff: 4,
        gBLSChangeSelecMictTime: 70,
        gBLSHistorySize: 4,
        gBLSSwitchThreshold: 1.2,
        gBLSDistanceWight: 0.5,
        gBLSdBWeight: 0.5,
        gBLSmaxTracksSize: 18,
        gBLSmicDataSaveWindowSize: 8
    },
    "5": {
        gBLSNoiseLevelThreshold: 220.0,
        gBLSDistanceDiff_X: 50,
        gBLSDistanceDiff_Y: 50,
        gBLSdBDiff: 5,
        gBLSChangeSelecMictTime: 80,
        gBLSHistorySize: 5,
        gBLSSwitchThreshold: 1.3,
        gBLSDistanceWight: 0.3,
        gBLSdBWeight: 0.7,
        gBLSmaxTracksSize: 20,
        gBLSmicDataSaveWindowSize: 10
    },
    "6": {
        gBLSNoiseLevelThreshold: 100.0,
        gBLSDistanceDiff_X: 20,
        gBLSDistanceDiff_Y: 20,
        gBLSdBDiff: 1,
        gBLSChangeSelecMictTime: 30,
        gBLSHistorySize: 1,
        gBLSSwitchThreshold: 0.8,
        gBLSDistanceWight: 0.7,
        gBLSdBWeight: 0.3,
        gBLSmaxTracksSize: 6,
        gBLSmicDataSaveWindowSize: 3
    },
    "7": {
        gBLSNoiseLevelThreshold: 110.0,
        gBLSDistanceDiff_X: 22,
        gBLSDistanceDiff_Y: 22,
        gBLSdBDiff: 2,
        gBLSChangeSelecMictTime: 35,
        gBLSHistorySize: 2,
        gBLSSwitchThreshold: 0.9,
        gBLSDistanceWight: 0.65,
        gBLSdBWeight: 0.35,
        gBLSmaxTracksSize: 6,
        gBLSmicDataSaveWindowSize: 3
    },
    "8": {
        gBLSNoiseLevelThreshold: 190.0,
        gBLSDistanceDiff_X: 38,
        gBLSDistanceDiff_Y: 38,
        gBLSdBDiff: 4,
        gBLSChangeSelecMictTime: 55,
        gBLSHistorySize: 4,
        gBLSSwitchThreshold: 1.2,
        gBLSDistanceWight: 0.45,
        gBLSdBWeight: 0.55,
        gBLSmaxTracksSize: 14,
        gBLSmicDataSaveWindowSize: 6
    },
    "9": {
        gBLSNoiseLevelThreshold: 230.0,
        gBLSDistanceDiff_X: 48,
        gBLSDistanceDiff_Y: 48,
        gBLSdBDiff: 5,
        gBLSChangeSelecMictTime: 75,
        gBLSHistorySize: 5,
        gBLSSwitchThreshold: 1.3,
        gBLSDistanceWight: 0.35,
        gBLSdBWeight: 0.65,
        gBLSmaxTracksSize: 20,
        gBLSmicDataSaveWindowSize: 10
    }
};

function applyEnvironmentConfig() {
    const select = document.getElementById('environmentSelect');
    const selectedConfig = environmentConfigs[select.value];

    // Update all input fields based on selected configuration
    Object.keys(selectedConfig).forEach(id => {
        const input = document.getElementById(id);
        if (input) {
            input.value = selectedConfig[id].toString();
            gInitialValues[id] = input.value;
            abouthandleInputChange();
        }
    });


    const tooltipSpan = document.getElementById('BLS_Environment_Tooltip');

    if (tooltipSpan) {
        const environmentNames = {
            "0": "Default",
            "1": "QuietOffice",
            "2": "NoisyCafe",
            "3": "ConferenceRoom",
            "4": "LargeLectureHall",
            "5": "OutdoorEvent",
            "6": "RecordingStudio",
            "7": "TelemedicineClinic"
        };
        const tooltipKey = `BLS_Environment_${environmentNames[select.value]}_Tooltip`;
        tooltipSpan.textContent = window.LanguageManager.getTranslatedText(tooltipKey) || 'No description available';
    }

    // Enable Apply and Cancel buttons
    const applyButton = document.getElementById('applyDebugSetupButton');
    const cancelButton = document.getElementById('cancelDebugSetupButton');
    if (applyButton && cancelButton) {
        applyButton.disabled = false;
        cancelButton.disabled = false;
    }
}

function exportDebugSettings() {
    const settings = {
        FunctionEnable: document.getElementById('SetFunctionCheckboxInput').checked,
        environmentSelect: document.getElementById('environmentSelect').value,
        ...Object.keys(inputMap).reduce((acc, id) => {
            const input = document.getElementById(id);
            if (input && id !== 'environmentSelect') {
                acc[inputMap[id]] = parseFloat(input.value) || parseInt(input.value);
            }
            return acc;
        }, {})
    };

    const now = new Date();
    const timestamp = now.toISOString().replace(/[:.]/g, '-');
    const filename = `DebugMode_${timestamp}.config`;

    const jsonString = JSON.stringify(settings, null, 2);

    const blob = new Blob([jsonString], { type: 'application/json' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
}


function importDebugSettings() {
    const fileInput = document.getElementById('importFileInput');
    fileInput.click();
}


function handleFileImport(input) {
    const file = input.files[0];
    if (!file) return;

    if (!file.name.endsWith('.config')) {
        alert('Please select a valid .config file.');
        input.value = '';
        return;
    }

    const reader = new FileReader();
    reader.onload = function (e) {
        try {
            const settings = JSON.parse(e.target.result);

            const debugModeCheckbox = document.getElementById('SetFunctionCheckboxInput');
            if (typeof settings.FunctionEnable === 'boolean') {
                debugModeCheckbox.checked = settings.FunctionEnable;
                onDebugModeChange(debugModeCheckbox);
                onFunctionChange(debugModeCheckbox);
            }


            const environmentSelect = document.getElementById('environmentSelect');
            if (settings.environmentSelect && environmentConfigs[settings.environmentSelect]) 
                {
                environmentSelect.value = settings.environmentSelect;
                applyEnvironmentConfig();
            }

            Object.keys(inputMap).forEach(id => {
                const input = document.getElementById(id);
                const key = inputMap[id];
                if (input && settings[key] !== undefined && id !== 'environmentSelect') {
                    input.value = settings[key].toString();
                    gInitialValues[id] = input.value;
                }
            });

            abouthandleInputChange();

            debugSetupApply();

        } catch (error) {
            alert('Error reading the configuration file: ' + error.message);
        }
    };
    reader.onerror = function () {
        alert('Error reading the file.');
    };
    reader.readAsText(file);

    input.value = '';
}

function updatedScheduleRebootSetting(obj) { 
    //console.log('updatedScheduleRebootSetting!!',obj);

    if( 'ScheduleRebootType' in obj)
    {
        if(obj.ScheduleRebootType == 0)
        {
            if(document.getElementById('DisableScheduleInptuRadio'))
            {
                document.getElementById('DisableScheduleInptuRadio').checked = true;
            }
        }
        if(obj.ScheduleRebootType == 1)//Daily
        {
            if(document.getElementById('DailyRebootInptuRadio'))
            {
                document.getElementById('DailyRebootInptuRadio').checked = true;
            }
        }
        if(obj.ScheduleRebootType == 2)//Timing
        {
            if(document.getElementById('RebootTimingInptuRadio'))
            {
                document.getElementById('RebootTimingInptuRadio').checked = true;
            }
        }
        
    }

    if( 'DailyRebootValue' in obj)
    {
        if(document.getElementById('DailyRebootTimeOption'))
        {
            $("#DailyRebootTimeOption").val(obj.DailyRebootValue); 
        }
    }

    if( 'RebootTimingValue' in obj)
    {
        if(document.getElementById('RebootTimingOption'))
        {
            $("#RebootTimingOption").val(obj.RebootTimingValue); 
        }
    }


}

function ScheduleRebootApply()
{
    var jsonmsg = {};
    jsonmsg.Command = "SetScheduleRebootSetting";
   

    /*var scheduleRebootTypeRadios = document.getElementsByName("ScheduleRebootType");
    var typeIndex = 0;
    for(typeIndex =0; typeIndex < scheduleRebootTypeRadios.r.length; typeIndex++)
    {
        if(scheduleRebootTypeRadios.r[typeIndex].checked)
        {
            jsonmsg.ScheduleRebootType = parseInt(scheduleRebootTypeRadios.r[typeIndex].value,10); 
            break;
        }
    }*/

    if(document.getElementById('DisableScheduleInptuRadio') && document.getElementById('DisableScheduleInptuRadio').checked== true )
    {
        jsonmsg.ScheduleRebootType = 0;//parseInt(scheduleRebootTypeRadios.r[typeIndex].value,10);
    }
    else if(document.getElementById('DailyRebootInptuRadio') && document.getElementById('DailyRebootInptuRadio').checked== true )
    {
        jsonmsg.ScheduleRebootType = 1;//parseInt(scheduleRebootTypeRadios.r[typeIndex].value,10);
    }
    else if(document.getElementById('RebootTimingInptuRadio') && document.getElementById('RebootTimingInptuRadio').checked== true )
    {
        jsonmsg.ScheduleRebootType = 2;//parseInt(scheduleRebootTypeRadios.r[typeIndex].value,10);
    }

    if(document.getElementById('DailyRebootTimeOption'))
    {
        jsonmsg.DailyRebootValue = parseInt(document.getElementById("DailyRebootTimeOption").value,10); 
    }

    if(document.getElementById('RebootTimingOption'))
    {
        jsonmsg.RebootTimingValue = parseInt(document.getElementById("RebootTimingOption").value,10); 
    }

    sendMessageSettings("SetScheduleRebootSetting",jsonmsg);
}

function ScheduleRebootCancel()
{
    sendMessageSettings("GetScheduleRebootSetting");
}

function updatedPipPositionValue() 
{
    for (i = 1; i < 3; i++) 
    {
        $("#PipCameraPosOption" + i + " option").remove();
    }

    for (i = 1; i < 3; i++) 
    {
        var selector = document.getElementById("PipCameraPosOption" + i);
        var option = new Option(window.LanguageManager.getTranslatedText("Off") , 0);
        if(selector)
            selector.appendChild(option);
        var currentValue = 0;
        for (j = 0; j < CamConnArray.length; j++) 
        {
            option = new Option(CamConnArray[j].DisplayName , j + 1);//option = new Option(CamConnArray[j].Camera , j + 1);
//                    console.log(i, option.value, option.text);
            if(selector)
                selector.appendChild(option);

            if(i <= SrcPosiArray.length)
            {
                if(CamConnArray[j].Camera === SrcPosiArray[i-1].Camera )
                {
                    currentValue = j + 1;
                }
            }
        }
        if(selector)
            $("#PipCameraPosOption" + i).val(currentValue);

    }
    
}

function updatePipMode(obj)
{
    if( 'IsEnablePIPMode' in obj)
    {
        if(obj.IsEnablePIPMode == true)
            document.getElementById("PipModeCheckboxInput").checked = true;
        else
            document.getElementById("PipModeCheckboxInput").checked = false;
    }
    if( 'SourcePositionArray' in obj)
    {
        if (obj.SourcePositionArray.length == 0)
            return;
        var i = 0;
        let size = SrcPosiArray.length;
        for (i = 0; i < size; i++)
            SrcPosiArray.pop();
        for (var idx = 0; idx < 2; idx++) {
            var rowData = {};
            rowData[ "Camera" ] = obj.SourcePositionArray[idx].Camera;
            rowData[ "Position" ] = obj.SourcePositionArray[idx].Position;
            SrcPosiArray.push(rowData);
        }
    }

}

function PipModeApply()
{
    var jsonmsg = {};
    jsonmsg.Command = "SetPipOutputSetting";
   

    if(document.getElementById('PipModeCheckboxInput') && document.getElementById('PipModeCheckboxInput').checked== true )
    {
        jsonmsg.IsEnablePIPMode = true;//parseInt(scheduleRebootTypeRadios.r[typeIndex].value,10);
    }
    else
        jsonmsg.IsEnablePIPMode = false;
    
        var tmp_data = [];
        for (var i = 1; i < 3; i++) {
            var rowData = {};
            rowData[ "Position" ] = i;
            rowData[ "Camera" ] = getSelectorText("PipCameraPosOption" + i);
            tmp_data.push(rowData);
        }
        jsonmsg.SourcePositionArray = tmp_data;

    //console.log("SetPipOutputSetting",jsonmsg);
    sendMessageAbout("SetPipOutputSetting",jsonmsg);
}

function PipModeCancel()
{
    sendMessageAbout("GetPipOutputSetting");
    sendMessageVideo("GetCameraList"); 
}

function PipCamPos1Changed()
{
    let CamPosit = [];
    var selElm = '';
    var selOpt = '';
    for (var i = 1; i < 3; i++) {
        selElm = document.getElementById("PipCameraPosOption" + i);
        selOpt = selElm.options[selElm.selectedIndex].text;
        CamPosit.push(selOpt);
    }
//    console.log('layoutCamPos', CamPosit);
    if ( (CamPosit[1] == CamPosit[0]))
        $("#PipCameraPosOption2").val(0);
}

function PipCamPos2Changed()
{
    let CamPosit = [];
    var selElm = '';
    var selOpt = '';
    for (var i = 1; i < 3; i++) {
        selElm = document.getElementById("PipCameraPosOption" + i);
        selOpt = selElm.options[selElm.selectedIndex].text;
        CamPosit.push(selOpt);
    }
    if (CamPosit[0] == CamPosit[1])
        $("#PipCameraPosOption1").val(0);
   
}

